/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationErrorIds;
import com.ibm.hwmca.fw.HwmcaParser;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.ntfy.AbstractSink;
import com.ibm.hwmca.fw.ntfy.AbstractSource;
import com.ibm.hwmca.fw.ntfy.MonitoredHashMap;
import com.ibm.hwmca.fw.ntfy.NotifyClassProperties;
import com.ibm.hwmca.fw.ntfy.NotifyConstants;
import com.ibm.hwmca.fw.ntfy.PersistentNotificationData;
import com.ibm.hwmca.fw.ntfy.Startable;
import com.ibm.hwmca.fw.persist.PersistenceClassNotFoundException;
import com.ibm.hwmca.fw.persist.PersistenceInvalidNameException;
import com.ibm.hwmca.fw.persist.PersistenceIsParentException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistencePersistentDataConstructorNotFoundException;
import com.ibm.hwmca.fw.persist.PersistenceReadException;
import com.ibm.hwmca.fw.persist.PersistenceUnsupportedVersionException;
import com.ibm.hwmca.fw.persist.PersistenceWriteException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NotificationService
implements Serializable,
NotifyConstants,
NotificationErrorIds {
    static final long serialVersionUID = -8098716187122198152L;
    private static final String TRACE_MASKT = "XNTYNTST";
    private static final String TRACE_MASKF = "XNTYNTSF";
    private static final String TRACE_MASKD = "XNTYNTSD";
    private static NotificationService MANAGER = null;
    public static final String NOTIFY_XML_FILE = "data/notify.xml";
    public static final String ADVANCED_USER_GLOBAL_KEY = "advanced";
    private static boolean retrievingPersistentInstance = false;
    private transient boolean _debug = false;
    private boolean _enabled = true;
    private HashMap _sourceClassProperties = new HashMap();
    private HashMap _sinkClassProperties = new HashMap();
    private HashMap _filterClassProperties = new HashMap();
    private MonitoredHashMap _sources;
    private MonitoredHashMap _sinks;
    private MonitoredHashMap _links;
    private MonitoredHashMap _globals;
    private MonitoredHashMap _users;
    private MonitoredHashMap _filters;
    private MonitoredHashMap _templates;
    private MonitoredHashMap _emailtemplates;

    public static NotificationService getManager() {
        if (MANAGER == null) {
            try {
                if (!retrievingPersistentInstance && MANAGER == null) {
                    retrievingPersistentInstance = true;
                    MANAGER = NotificationService.retrieveData();
                    retrievingPersistentInstance = false;
                    MANAGER.start();
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "getManager:  exception retrieving persistent data");
                Trace.trace(TRACE_MASKF, e);
            }
        }
        if (MANAGER == null) {
            Trace.trace(TRACE_MASKF, "getManager:  creating new manager");
            MANAGER = new NotificationService();
        }
        return MANAGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NotificationService retrieveData() throws IOException, ClassNotFoundException {
        PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
        PersistentNotificationData pnd = null;
        if (pMgr.contains("com.ibm.hwmca.fw.ntfy.NotificationDataKey")) {
            Trace.trace(TRACE_MASKF, "Have persistent data, reading it in");
            try {
                try {
                    pnd = (PersistentNotificationData)pMgr.read("com.ibm.hwmca.fw.ntfy.NotificationDataKey");
                }
                catch (PersistenceIsParentException pipe) {
                    Trace.trace(TRACE_MASKF, pipe);
                    Object var4_3 = null;
                    if (pnd != null) return pnd.getNotificationService();
                    Trace.trace(TRACE_MASKF, "error reading in persistent version, recreating");
                    pnd = new PersistentNotificationData();
                    return pnd.getNotificationService();
                }
                catch (PersistenceReadException pre) {
                    Trace.trace(TRACE_MASKF, pre);
                    Object var4_4 = null;
                    if (pnd != null) return pnd.getNotificationService();
                    Trace.trace(TRACE_MASKF, "error reading in persistent version, recreating");
                    pnd = new PersistentNotificationData();
                    return pnd.getNotificationService();
                }
                catch (PersistenceClassNotFoundException pcnfe) {
                    Trace.trace(TRACE_MASKF, pcnfe);
                    Object var4_5 = null;
                    if (pnd != null) return pnd.getNotificationService();
                    Trace.trace(TRACE_MASKF, "error reading in persistent version, recreating");
                    pnd = new PersistentNotificationData();
                    return pnd.getNotificationService();
                }
                catch (PersistencePersistentDataConstructorNotFoundException ppdcnfe) {
                    Trace.trace(TRACE_MASKF, ppdcnfe);
                    Object var4_6 = null;
                    if (pnd != null) return pnd.getNotificationService();
                    Trace.trace(TRACE_MASKF, "error reading in persistent version, recreating");
                    pnd = new PersistentNotificationData();
                    return pnd.getNotificationService();
                }
                catch (PersistenceUnsupportedVersionException puve) {
                    Trace.trace(TRACE_MASKF, puve);
                    Object var4_7 = null;
                    if (pnd != null) return pnd.getNotificationService();
                    Trace.trace(TRACE_MASKF, "error reading in persistent version, recreating");
                    pnd = new PersistentNotificationData();
                    return pnd.getNotificationService();
                }
                Object var4_2 = null;
                if (pnd != null) return pnd.getNotificationService();
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                if (pnd != null) throw throwable;
                Trace.trace(TRACE_MASKF, "error reading in persistent version, recreating");
                pnd = new PersistentNotificationData();
                throw throwable;
            }
            Trace.trace(TRACE_MASKF, "error reading in persistent version, recreating");
            pnd = new PersistentNotificationData();
            return pnd.getNotificationService();
        }
        Trace.trace(TRACE_MASKF, "no persistent version available, making a fresh one");
        pnd = new PersistentNotificationData();
        try {
            pMgr.write("com.ibm.hwmca.fw.ntfy.NotificationDataKey", pnd);
            return pnd.getNotificationService();
        }
        catch (PersistenceIsParentException pipe) {
            Trace.trace(TRACE_MASKF, pipe);
            return pnd.getNotificationService();
        }
        catch (PersistenceInvalidNameException pine) {
            Trace.trace(TRACE_MASKF, pine);
            return pnd.getNotificationService();
        }
        catch (PersistenceWriteException pwe) {
            Trace.trace(TRACE_MASKF, pwe);
        }
        return pnd.getNotificationService();
    }

    public static void saveData() throws IOException {
        Trace.trace(TRACE_MASKT, "-> saveData()");
        PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
        try {
            pMgr.write("com.ibm.hwmca.fw.ntfy.NotificationDataKey", new PersistentNotificationData());
        }
        catch (PersistenceIsParentException pipe) {
            Trace.trace(TRACE_MASKF, pipe);
        }
        catch (PersistenceInvalidNameException pine) {
            Trace.trace(TRACE_MASKF, pine);
        }
        catch (PersistenceWriteException pwe) {
            Trace.trace(TRACE_MASKF, pwe);
        }
        Trace.trace(TRACE_MASKT, "<- saveData");
    }

    private NotificationService() {
        Trace.trace(TRACE_MASKT, "-> NotificationService()");
        try {
            this.readXML(NOTIFY_XML_FILE);
            this._sources = new MonitoredHashMap();
            this._sinks = new MonitoredHashMap();
            this._links = new MonitoredHashMap();
            this._globals = new MonitoredHashMap();
            this._filters = new MonitoredHashMap();
            this._users = new MonitoredHashMap();
            this._templates = new MonitoredHashMap();
            this._emailtemplates = new MonitoredHashMap();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKT, "<- NotificationService");
    }

    public void setDebug(boolean setting) {
        this._debug = setting;
    }

    public boolean isDebugging() {
        return this._debug;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public Map getGlobalProperties() {
        return this._globals;
    }

    public Map getUserProperties() {
        return this._users;
    }

    public Map getFilterProperties() {
        return this._filters;
    }

    public Map getFilterClassProperties() {
        return this._filterClassProperties;
    }

    public NotifyClassProperties getSourceClassProperties(String sourceClassName) {
        return (NotifyClassProperties)this._sourceClassProperties.get(sourceClassName);
    }

    public NotifyClassProperties getSinkClassProperties(String sinkClassName) {
        return (NotifyClassProperties)this._sinkClassProperties.get(sinkClassName);
    }

    private void readXML(String xmlFileName) throws IOException, SAXException {
        Trace.trace(TRACE_MASKT, "-> readXML(" + xmlFileName + ")");
        FileInputStream xmlStream = new FileInputStream(xmlFileName);
        Document config = new HwmcaParser(xmlStream, false).getDocument();
        this.parseSources(config.getElementsByTagName("source"));
        this.parseSinks(config.getElementsByTagName("sink"));
        this.parseFilters(config.getElementsByTagName("filter"));
        Trace.trace(TRACE_MASKT, "<- readXML");
    }

    private void parseSources(NodeList sources) {
        Trace.trace(TRACE_MASKT, "-> parseSources(" + sources + ")");
        int count = sources.getLength();
        Element source = null;
        String sourceName = null;
        NotifyClassProperties props = null;
        NodeList uiinfo = null;
        for (int i = 0; i < count; ++i) {
            source = (Element)sources.item(i);
            sourceName = source.getAttribute("class");
            if (this._sourceClassProperties.containsKey(sourceName)) {
                props = (NotifyClassProperties)this._sourceClassProperties.get(sourceName);
            } else {
                props = this.getProperties(source);
                this._sourceClassProperties.put(sourceName, props);
            }
            uiinfo = source.getElementsByTagName("uiinfo");
            if (uiinfo.getLength() != 1) continue;
            props.put("uiinfo", this.getProperties((Element)uiinfo.item(0)));
        }
        Trace.trace(TRACE_MASKT, "<- parseSources");
    }

    private void parseSinks(NodeList sinks) {
        Trace.trace(TRACE_MASKT, "-> parseSinks(" + sinks + ")");
        int count = sinks.getLength();
        Element sink = null;
        String sinkName = null;
        NotifyClassProperties props = null;
        NodeList uiinfo = null;
        for (int i = 0; i < count; ++i) {
            sink = (Element)sinks.item(i);
            sinkName = sink.getAttribute("class");
            if (this._sinkClassProperties.containsKey(sinkName)) {
                props = (NotifyClassProperties)this._sinkClassProperties.get(sinkName);
            } else {
                props = this.getProperties(sink);
                this._sinkClassProperties.put(sinkName, props);
            }
            uiinfo = sink.getElementsByTagName("uiinfo");
            if (uiinfo.getLength() != 1) continue;
            props.put("uiinfo", this.getProperties((Element)uiinfo.item(0)));
        }
        Trace.trace(TRACE_MASKT, "<- parseSinks");
    }

    private void parseFilters(NodeList filters) {
        Trace.trace(TRACE_MASKT, "-> parseFilters(" + filters + ")");
        int count = filters.getLength();
        Element filter = null;
        String filterName = null;
        NotifyClassProperties props = null;
        NodeList uiinfo = null;
        for (int i = 0; i < count; ++i) {
            filter = (Element)filters.item(i);
            filterName = filter.getAttribute("class");
            if (this._filterClassProperties.containsKey(filterName)) {
                props = (NotifyClassProperties)this._filterClassProperties.get(filterName);
            } else {
                props = this.getProperties(filter);
                this._filterClassProperties.put(filterName, props);
            }
            uiinfo = filter.getElementsByTagName("uiinfo");
            if (uiinfo.getLength() != 1) continue;
            props.put("uiinfo", this.getProperties((Element)uiinfo.item(0)));
        }
        Trace.trace(TRACE_MASKT, "<- parseFilters");
    }

    private NotifyClassProperties getProperties(Element e) {
        Trace.trace(TRACE_MASKT, "-> getProperties(" + e + ")");
        NotifyClassProperties props = new NotifyClassProperties();
        NamedNodeMap attributes = e.getAttributes();
        Attr attribute = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            attribute = (Attr)attributes.item(i);
            props.put(attribute.getName(), attribute.getValue());
        }
        Trace.trace(TRACE_MASKT, "<- getProperties returning:  " + props);
        return props;
    }

    private void showConfig(Document config) {
        Trace.trace(TRACE_MASKT, "-> showConfig(" + config + ")");
        NodeList sources = config.getElementsByTagName("source");
        int sourceCount = sources.getLength();
        System.out.println("NotificationService.java -> showConfig:  source count is " + sourceCount);
        Element source = null;
        for (int i = 0; i < sourceCount; ++i) {
            source = (Element)sources.item(i);
            System.out.println("  NotificationService.java -> showConfig:  name is " + source.getAttribute("name"));
            System.out.println("  NotificationService.java -> showConfig:  class is " + source.getAttribute("class"));
            System.out.println("  NotificationService.java -> showConfig:  enabled is " + source.getAttribute("enabled"));
            NodeList uiinfo = source.getElementsByTagName("uiinfo");
            if (uiinfo.getLength() == 1) {
                NamedNodeMap attributes = uiinfo.item(0).getAttributes();
                Attr attribute = null;
                for (int j = 0; j < attributes.getLength(); ++j) {
                    attribute = (Attr)attributes.item(j);
                    System.out.println("    NotificationService.java -> showConfig:  " + attribute.getName() + "=" + attribute.getValue());
                }
            }
            System.out.println("");
            Properties uiProps = new Properties();
        }
        NodeList sinks = config.getElementsByTagName("sink");
        System.out.println("NotificationService.java -> showConfig:  sink count is " + sinks.getLength());
        Element sink = null;
        for (int i = 0; i < sinks.getLength(); ++i) {
            sink = (Element)sinks.item(i);
            System.out.println("  NotificationService.java -> showConfig:  name is " + sink.getAttribute("name"));
            System.out.println("  NotificationService.java -> showConfig:  class is " + sink.getAttribute("class"));
            System.out.println("  NotificationService.java -> showConfig:  enabled is " + sink.getAttribute("enabled"));
            NodeList uiinfo = sink.getElementsByTagName("uiinfo");
            if (uiinfo.getLength() == 1) {
                NamedNodeMap attributes = uiinfo.item(0).getAttributes();
                Attr attribute = null;
                for (int j = 0; j < attributes.getLength(); ++j) {
                    attribute = (Attr)attributes.item(j);
                    System.out.println("    NotificationService.java -> showConfig:  " + attribute.getName() + "=" + attribute.getValue());
                }
            }
            System.out.println("");
        }
        Trace.trace(TRACE_MASKT, "<- showConfig");
    }

    private void start() {
        this.sendStartables(true);
    }

    private void shutdown() {
        this.sendStartables(false);
    }

    private void sendStartables(boolean start) {
        Trace.trace(TRACE_MASKT, "-> sendStartables(" + start + ")");
        ArrayList startables = new ArrayList(this._sinks.size() + this._sources.size());
        startables.addAll(this._sinks.values());
        startables.addAll(this._sources.values());
        startables.addAll(this._links.values());
        Iterator i = startables.iterator();
        Object item = null;
        while (i.hasNext()) {
            item = i.next();
            if (!(item instanceof Startable)) continue;
            if (start) {
                this.startStartable(item);
                continue;
            }
            this.stopStartable(item);
        }
        Trace.trace(TRACE_MASKT, "<- sendStartables");
    }

    private void startStartable(Startable obj) {
        try {
            if (!obj.isStarted()) {
                obj.start();
            }
        }
        catch (Exception e) {
            new FrameworkLog(NotificationErrorIds._logInfo, -32737, e).log(LogAttributes.INFO_LOG);
        }
    }

    private void stopStartable(Startable obj) {
        try {
            if (obj.isStarted()) {
                obj.stop();
            }
        }
        catch (Exception e) {
            new FrameworkLog(NotificationErrorIds._logInfo, -32736, e).log(LogAttributes.INFO_LOG);
        }
    }

    public Map getSourceClassPropertyMap() {
        return this._sourceClassProperties;
    }

    public Map getSinkClassPropertyMap() {
        return this._sinkClassProperties;
    }

    public Map getSources() {
        return this._sources;
    }

    public Map getSinks() {
        return this._sinks;
    }

    public Map getFilters() {
        return this._filters;
    }

    public Map getUsers() {
        return this._users;
    }

    public Map getTemplates() {
        return this._templates;
    }

    public Map getEmailTemplates() {
        return this._emailtemplates;
    }

    public Map getLinks() {
        return this._links;
    }

    public Map getSinksWithClassName(String className) {
        Trace.trace(TRACE_MASKT, "-> getSinksWithClassName(" + className + ")");
        HashMap<String, AbstractSink> sinks = new HashMap<String, AbstractSink>();
        NotifyClassProperties props = (NotifyClassProperties)this.getSinkClassPropertyMap().get(className);
        String cName = props.getClassName();
        Iterator i = this.getSinks().values().iterator();
        AbstractSink item = null;
        while (i.hasNext()) {
            item = (AbstractSink)i.next();
            if (!item.getClass().getName().equals(cName)) continue;
            sinks.put(item.getName(), item);
        }
        Trace.trace(TRACE_MASKT, "<- getSinksWithClassName returning " + sinks.size() + " sinks");
        return sinks;
    }

    public Map getSourcesWithClassName(String className) {
        Trace.trace(TRACE_MASKT, "-> getSourcesWithClassName(" + className + ")");
        HashMap<String, AbstractSource> sources = new HashMap<String, AbstractSource>();
        NotifyClassProperties props = (NotifyClassProperties)this.getSourceClassPropertyMap().get(className);
        String cName = props.getClassName();
        Iterator i = this.getSources().values().iterator();
        AbstractSource item = null;
        while (i.hasNext()) {
            item = (AbstractSource)i.next();
            if (!item.getClass().getName().equals(cName)) continue;
            sources.put(item.getName(), item);
        }
        Trace.trace(TRACE_MASKT, "<- getSourcesWithClassName returning " + sources.size() + " sources");
        return sources;
    }

    public String getSmtpServer() {
        try {
            return (String)this.getGlobalProperties().get("smtpserver");
        }
        catch (Exception e) {
            return "";
        }
    }

    public int getSmtpPort() {
        try {
            return (Integer)this.getGlobalProperties().get("smtpport");
        }
        catch (Exception e) {
            return 0;
        }
    }
}

